import { ContactType } from "../types/ResType";
import { useAppSelector } from "../utils/hooks";

export default function ShowSavedName({
  user_id,
  name,
}: {
  user_id: string;
  name: string;
}) {
  const ContactList = useAppSelector((state) => state.ContactList);

  return (
    <div className="capitalize">
      {ContactList?.data?.find(
        (e: ContactType) => e?.user_id.toString() == user_id,
      )?.name ?? name}
    </div>
  );
}
