import LoadingSkeletonImageDynamic from "../../../components/LoadingSkeletonImageDynamic";
import { ClipLoader } from "react-spinners";
import { useTheme } from "../../../context/ThemeProvider";
import { useCallHistory } from "../../../store/api/useCallHistory";
import CallInCallHistory from "./CallInCallHistory";
import { formatCallDuration, formatDate, formatTime } from "../../../utils/formatUTCtoLocalDate";
import ShowSavedName from "../../../components/ShowSavedName";
import SearchNotFoundAnimation from "../../../components/SearchNotFoundAnimation";


export default function AllCallsHIstory() {
  const { data: callHistory, isLoading } = useCallHistory();

  const { theme } = useTheme();

  return (
    <div className="flex h-[75vh] w-full max-w-full flex-col overflow-y-auto overflow-x-hidden pb-24 lg:my-5 lg:pb-0">
      {isLoading ? (
        <div className="grid h-full place-content-center">
          <ClipLoader size={23} color={theme == "dark" ? "white" : "black"} />
        </div>
      ) : callHistory?.data?.Records?.length == 0 ? (
        <div className="grid h-96 place-content-center gap-5">
          <SearchNotFoundAnimation />
          <div>No Calls found</div>
        </div>
      ) : callHistory?.data?.Records.length == 0 ? (
        <div className="grid h-96 place-content-center gap-5">
          <SearchNotFoundAnimation />
          <div>No Calls Found</div>
        </div>
      ) : (
        callHistory?.data?.Records.filter((e) => e?.Calls.length > 0).map((e) => {
          return (
            <>
              <div
                onClick={() => { }}
                onContextMenu={() => { }}
                //   key={e.id}
                className={`flex cursor-pointer items-center px-3 py-4 hover:bg-selectedChat ${false && "bg-selectedChat"}`}
              >
                <div className="relative mr-3">
                  <LoadingSkeletonImageDynamic
                    radius=""
                    className="min-h-12 min-w-12 rounded-full object-cover 2xl:h-12 2xl:w-12"
                    image_height="100%"
                    image_url={
                      e?.Chat.chat_type == "group"
                        ? e?.Chat.group_icon
                        : e?.Calls[0].caller.profile_pic
                    }
                    image_width=""
                  />
                </div>
                <div className="flex w-full items-center justify-between">
                  <div>
                    <div className="text-base font-medium capitalize text-darkText">
                      {e?.Chat.chat_type == "group" ? (
                        e?.Chat.group_name
                      ) : (
                        <ShowSavedName
                          user_id={e?.Calls[0].caller.user_id.toString()}
                          name={e?.Calls[0].caller.user_name}
                        />
                      )}
                    </div>
                    <CallInCallHistory callData={e} />
                  </div>
                  <div className="space-y-1 text-end text-sm text-lightText">
                    <div>{formatDate(e.createdAt.toString())}</div>
                    <div className="text-xs">{formatCallDuration(e.Calls[0].call_duration)}</div>
                  </div>
                </div>
              </div>
              <hr className="border-t border-borderColor" />
            </>
          );
        })
      )}
    </div>
  );
}
