import { FaChevronLeft } from "react-icons/fa6";
import { useNavigate } from "react-router-dom";
import TextTranslate from "../../../utils/TextTranslate";
import CallHistoryTabs from "./CallHistoryTabs";

export default function CallHIstory() {
  const navigate = useNavigate();

  return (
    // <div className="relative flex h-screen min-w-96 flex-col bg-secondary pb-0 pt-16 shadow-inner 2xl:min-w-96">
    <div className="relative flex h-screen w-full flex-col overflow-y-auto overflow-x-hidden bg-primary pb-6 shadow-inner lg:max-w-md">
      <div className="w-full px-4">
        <div className="lg:mb-10 mb-5 flex items-center gap-3 lg:pt-10 pt-5 font-semibold">
          <FaChevronLeft
            className="cursor-pointer"
            onClick={() => {
              navigate(-1);
            }}
          />
          <span className="text-lg font-semibold">
            <TextTranslate text="Call History" />
          </span>
        </div>
      </div>
      <CallHistoryTabs />
    </div>
  );
}
