import { FaPlus } from "react-icons/fa";
import { useFile } from "../../../context/FileProvider";
import { useEffect, useState } from "react";

export default function GroupProfileImage() {
  const { selectedFile, setSelectedFile } = useFile();
  const [selectedFileUrl, setSelectedFileUrl] = useState("");

  const onFileChange = (event: React.ChangeEvent<HTMLInputElement>) => {
    if (event.target.files![0]) {
      setSelectedFile(null);
    }
    const files = event.target.files![0];
    if (!files) return;
    setSelectedFile(files);
  };

  useEffect(() => {
    if (selectedFile) {
      setSelectedFileUrl(URL.createObjectURL(selectedFile));
    }
  }, [selectedFile]);

  return (
    <div className="grid w-full place-content-center pt-14 lg:pt-3">
      <label
        htmlFor="groupPhotoInput"
        className="relative mx-auto w-fit cursor-pointer"
      >
        {selectedFile == null ? (
          <img
            src={"/Home/empty_group_profile.png"}
            className="h-32 w-32 rounded-full bg-secondary object-cover p-2"
            alt=""
          />
        ) : (
          <img
            src={selectedFileUrl}
            className="h-32 w-32 rounded-full bg-secondary object-cover p-2"
            alt=""
          />
        )}
        <input
          onChange={onFileChange}
          accept="image/*"
          className="hidden"
          type="file"
          id="groupPhotoInput"
        />
        <div className="absolute bottom-1 right-2 z-10 grid h-8 w-8 cursor-pointer place-content-center rounded-full bg-primary">
          <FaPlus className="primary-gradient rounded-full p-1 text-xl" />
        </div>
        {/* {selectedFile == null && (
          <div className="absolute top-0 flex flex-col items-center justify-center text-center text-sm h-32 w-32">
            <div className="mb-2 grid h-8 w-8 place-content-center rounded-full bg-[#9E9E9E]">
              <FiPlus className="h-7 w-7" />
            </div>
            <div>Add Group</div>
            <div>Icon</div>
          </div>
        )} */}
      </label>
    </div>
  );
}
