import { useTheme } from "../../../context/ThemeProvider";
import { useAppSelector } from "../../../utils/hooks";
import chatSidebarTime from "../../../utils/chatSidebarTime";
import TextTranslate from "../../../utils/TextTranslate";
import { useConversationDocuments } from "../../../store/api/useConversationDocuments";
import SearchNotFoundAnimation from "../../../components/SearchNotFoundAnimation";

export default function Documents() {
  const { theme } = useTheme();
  const { data } = useConversationDocuments();
  const userData = useAppSelector((state) => state.userData);

  return (
    <div className="space-y-4">
      <div className="space-y-3">
        {data?.data?.Records.length == 0 ||
        data?.data?.Records.length == undefined ? (
          <div className="grid h-96 place-content-center text-center gap-5">
            <SearchNotFoundAnimation />
            <div>
              <TextTranslate text="No Document Found" />
            </div>
          </div>
        ) : (
          data?.data?.Records.map((message) => {
            return (
              <>
                {message.sender_id == userData.user_id ? (
                  <div className="ml-auto w-[90%]">
                    <div className="w-full rounded-[9px] rounded-br-none bg-[#FFEDAB] px-1 pb-3 pt-1">
                      <a
                        href={message.message_content}
                        target="_blank"
                        className={`flex items-center justify-between gap-2 rounded-[7px] p-4 text-sm ${theme == "dark" ? "bg-[#1D1D1D]" : "bg-[#FAFAFA]"}`}
                      >
                        <div className="flex items-center gap-2">
                          <img
                            className="h-10 w-10 object-cover"
                            src="/DarkIcons/pdf_icons.png"
                            alt=""
                          />
                          <div className="line-clamp-2 max-w-48">
                            {message?.message_content
                              ?.split("/")
                              .pop()
                              ?.split("-")
                              .slice(1)
                              .join("-") || ""}
                          </div>
                        </div>
                        <img
                          src="/DarkIcons/Download_icon.png"
                          className="h-8 w-8 cursor-pointer"
                          alt=""
                        />
                      </a>
                    </div>
                    <div className="mt-2 text-right text-sm opacity-60">
                      {chatSidebarTime(message.createdAt)}
                    </div>
                  </div>
                ) : (
                  <div className="">
                    <div className="w-[90%] rounded-[9px] rounded-bl-none bg-pdfBg px-1 pb-3 pt-1">
                      <a
                        href={message.message_content}
                        target="_blank"
                        className={`flex items-center justify-between gap-2 rounded-[7px] p-4 px-6 text-sm ${theme == "dark" ? "bg-[#1D1D1D]" : "bg-[#FAFAFA]"}`}
                      >
                        <div className="flex items-center gap-2">
                          <img
                            className="h-10 w-10 object-cover"
                            src="/DarkIcons/pdf_icons.png"
                            alt=""
                          />
                          <div>
                            {message?.message_content
                              ?.split("/")
                              .pop()
                              ?.split("-")
                              .slice(1)
                              .join("-") || ""}
                          </div>
                        </div>
                        <img
                          src="/DarkIcons/Download_icon.png"
                          className="h-8 w-8 cursor-pointer"
                          alt=""
                        />
                      </a>
                    </div>
                    <div className="mt-2 text-sm opacity-60">
                      {chatSidebarTime(message.createdAt)}
                    </div>
                  </div>
                )}
              </>
            );
          })
        )}
      </div>
    </div>
  );
}
