import { Dialog, DialogPanel } from "@headlessui/react";
import { useAppDispatch, useAppSelector } from "../../../../utils/hooks";
import GiphyComponent from "./GiphyComponent";
import { updateSendMessageData } from "../../../../store/Slices/SendMessageSlice";

export default function GiphyComponentModal() {
  const dispatch = useAppDispatch();
  const SendMessageData = useAppSelector((state) => state.SendMessageData);

  const close = () => {
    dispatch(updateSendMessageData({ showGiphyPicker: false }));
  };

  return (
    <Dialog
      open={SendMessageData.showGiphyPicker}
      as="div"
      className="relative z-10"
      onClose={close}
    >
      <div className="fixed inset-0 z-10 flex min-h-full items-center justify-center p-4 backdrop-blur-sm">
        <DialogPanel className="data-[closed]:transform-[scale(95%)] max-h-[80vh] w-full max-w-lg overflow-hidden rounded-xl bg-modalBg shadow-lg backdrop-blur-md transition-all duration-300 ease-in-out data-[closed]:opacity-0">
          <GiphyComponent />
        </DialogPanel>
      </div>
    </Dialog>
  );
}
