/* eslint-disable no-unsafe-optional-chaining */
import { useAppDispatch } from "../../../../utils/hooks";
import { updateViewState } from "../../../../store/Slices/ViewManagerSlice";
import { updateSendMessageData } from "../../../../store/Slices/SendMessageSlice";
import { formatRelative } from "date-fns";
import { useStatusDetails } from "../../../../store/api/useStatusDetails";
import { useAppSelector } from "../../../../utils/hooks";
import ShowSavedName from "../../../../components/ShowSavedName";

export default function StatusViewes() {
  const dispatch = useAppDispatch();
  const statusViews = useStatusDetails().data?.data.views;
  const showStatusViews = useAppSelector((state) => state.ViewManager.showStatusViews);

  function close() {
    dispatch(updateViewState({ showStatusViews: false }));
    dispatch(updateSendMessageData({ status_id: 0 }));
  }
  console.log(statusViews?.length, "statusViews?.length");


  return (
    <>
      {/* 🧾 Bottom Sheet */}
      {showStatusViews && (
        <div className="absolute bottom-0 left-0 right-0 z-[9999] max-h-[80vh] overflow-hidden rounded-t-2xl bg-secondary p-4 shadow-lg transition-all duration-300">
          <div className="flex items-center justify-between  pb-2">
            <h2 className="text-lg font-semibold text-darkText">Status Views</h2>
            <button onClick={close} className="text-lightText hover:opacity-75">
              Close
            </button>
          </div>

          <div className="custom-scrollbar mt-4 max-h-[40vh] overflow-y-auto pr-2">
            {statusViews?.length && statusViews?.length > 0 ? (
              statusViews?.map((item) => (
                <div
                  key={item.user_id}
                  className="flex items-center gap-3 py-2"
                >
                  <img
                    src={item.profile_pic}
                    className="h-10 w-10 rounded-full object-cover"
                    alt=""
                  />
                  <div className="flex flex-col">
                    <div className="text-sm text-darkText">
                      {/* {item.first_name} {item.last_name} */}
                      <ShowSavedName user_id={item.user_id.toString()} name={item.full_name} />
                    </div>
                    <div className="text-xs text-gray-400">
                      {/* {formatRelative(item.updatedAt, new Date())} */}
                      {item.user_name}
                    </div>
                  </div>
                </div>
              ))
            ) : (
              <div className="py-4 text-center text-sm text-white">
                No views yet.
              </div>
            )}
          </div>
        </div>
      )}
    </>
  );
}
