import React from "react";

export default function LoginLeftSections() {
  return (
    <div
      className="relative col-span-1 hidden h-full w-full place-content-center rounded-r-[2.5rem] bg-cover text-themeTextColor bg-center lg:grid"
      style={{
        backgroundImage: `url("/Home/signin_bg.jpg")`,
      }}
    >
      {/* Overlay with theme color */}
      <div
        className="absolute inset-0  rounded-r-[2.5rem]"
        style={{ backgroundColor: "var(--theme-color)" }}
      />

      {/* Content */}
      <div className="relative z-10 mb-28">
        <img
          src="/Home/signin_image.png"
          className="ml-auto mr-auto h-full w-full px-10 max-w-[60%] object-contain"
          alt=""
        />
        <div className="my-10 text-center text-xl font-medium">
          <div>Chat effortlessly with friends and</div>
          <div>family anytime, anywhere!</div>
        </div>

        <div className="text-center font-medium">
          Share photos and chat anytime.
        </div>
      </div>
    </div>

  );
}
