import { createSlice, PayloadAction } from "@reduxjs/toolkit";

interface ForwareMessageState {
  selectMessage: boolean;
  forwarded_conversations_id: number[];
  forwarded_user_id: number[];
}

const initialState: ForwareMessageState = {
  selectMessage: false,
  forwarded_conversations_id: [],
  forwarded_user_id: [],
};

const ForwardMessageSlice = createSlice({
  name: "ForwardMessage",
  initialState,
  reducers: {
    updateForwardedList(
      state,
      action: PayloadAction<{ chat_id: number }>
    ) {
      const { chat_id } = action.payload;
      if (!state.forwarded_conversations_id.includes(chat_id)) {
        state.forwarded_conversations_id.push(chat_id);
      } else {
        state.forwarded_conversations_id =
          state.forwarded_conversations_id.filter((id) => id !== chat_id);
      }
    },

    updateForwardedUserId(
      state,
      action: PayloadAction<{ user_id: number }>
    ) {
      const { user_id } = action.payload;
      if (!state.forwarded_user_id.includes(user_id)) {
        state.forwarded_user_id.push(user_id);
      } else {
        state.forwarded_user_id = state.forwarded_user_id.filter(
          (id) => id !== user_id
        );
      }
    },

    clearnForwardedList(state) {
      state.forwarded_conversations_id = [];
      state.forwarded_user_id = [];
    },
  },
});

export default ForwardMessageSlice.reducer;
export const {
  updateForwardedList,
  updateForwardedUserId,
  clearnForwardedList,
} = ForwardMessageSlice.actions;
