import { createSlice, PayloadAction } from "@reduxjs/toolkit";

interface PeerJsSliceType {
  isVideoEnabled: boolean;
  isAudioEnabled: boolean;
  isScreenSharing: boolean;
  peer_id: string;
  room_id: string;
  call_id: number;
  chat_id: string;
}

const initialState: PeerJsSliceType = {
  isVideoEnabled: true,
  isAudioEnabled: true,
  isScreenSharing: false,
  peer_id: "",
  room_id: sessionStorage.getItem("room_id") || "",
  call_id: Number(sessionStorage.getItem("call_id") || 0),  
  chat_id: sessionStorage.getItem("chat_id") || "",
};

const peerJsSlice = createSlice({
  name: "PeerJsSlice",
  initialState,
  reducers: {
    
    updatePeerData(state, action: PayloadAction<Partial<PeerJsSliceType>>) {
        console.log("action.payload", action.payload);
      return { ...state, ...action.payload };
    },
  },
});

export const { updatePeerData } = peerJsSlice.actions;
export default peerJsSlice.reducer;
