export interface CallHistoryRes {
  status: boolean;
  data: Data;
  message: string;
  toast: number;
}

export interface Data {
  Records: CallRecord[];
  Pagination: Pagination;
}

export interface Pagination {
  total_pages: number;
  total_records: number;
  current_page: number;
  records_per_page: number;
}

export interface CallRecord {
  message_content: MessageContent;
  message_thumbnail: string;
  reply_to: number;
  social_id: number;
  message_id: number;
  message_type: "call";
  message_length: string;
  message_seen_status: MessageSeenStatus;
  message_size: string;
  deleted_for: string[];
  starred_for: string[];
  deleted_for_everyone: boolean;
  pinned: boolean;
  pin_lifetime: null;
  peer_user: null;
  pinned_till: null;
  forwarded_from: number;
  createdAt: Date;
  updatedAt: Date;
  chat_id: number;
  sender_id: number;
  story_id: null;
  Calls: Call[];
  Chat: Chat;
}

export interface Call {
  call_id: number;
  call_type: CallType;
  call_duration: number;
  call_status: MessageContent;
  caller: Caller;
}

export enum MessageContent {
  Ended = "ended",
  Missed = "missed",
  Ongoing = "ongoing",
  Rejected = "rejected",
}

export enum CallType {
  Audio = "audio",
  Video = "video",
}

export interface Caller {
  user_name: string;
  profile_pic: string;
  user_id: number;
}

export interface Chat {
  group_icon: string;
  chat_id: number;
  chat_type: ChatType;
  group_name: string;
}

export enum ChatType {
  Group = "group",
  Private = "private",
}

export enum MessageSeenStatus {
  Seen = "seen",
  Sent = "sent",
}
