import { Message } from "../types/MessageListType";

export default function insertDateDividers(messages: Message[]): Message[] {
  const result: Message[] = [];
  let lastDate: string | null = null;

  for (const msg of messages) {
    // Convert to UTC ISO string (e.g., "2025-07-16T00:00:00.000Z")
    const msgDateUTC = new Date(msg.createdAt).toISOString().split("T")[0]; // e.g., "2025-07-16"

    if (msgDateUTC !== lastDate) {
      lastDate = msgDateUTC;

      result.push({
        ...msg,
        message_type: "date",
        message_content: msgDateUTC, // store raw UTC date string
        message_id: Number(`999${Date.parse(msg.createdAt)}`), // temporary unique ID
        createdAt: msg.createdAt,
      });
    }

    result.push(msg);
  }

  return result;
}
