import CreateGroupHeader from "./CreateGroupHeader";
import GroupProfileImage from "./GroupProfileImage";
import GroupNameInput from "./GroupNameInput";
import GroupDescriptionInput from "./GroupDescriptionInput";
import GroupMembersList from "./GroupMembersList";
import DoneButton from "./DoneButton";
import { useContactList } from "../../../store/api/useContactList";
import { useAppSelector } from "../../../utils/hooks";
import { useGroupSettings } from "../../../store/api/useGroupSettings";
import TextTranslate from "../../../utils/TextTranslate";

export default function CreateGroupComponent() {
  useContactList();
  const CreateGroup = useAppSelector((state) => state.CreateGroup);
  const { data: groupSettingsData } = useGroupSettings();

  return (
    <div className="relative flex h-[100dvh] min-w-80 flex-col bg-secondary shadow-inner 2xl:min-w-96">
      <div
        style={{
          backgroundSize: "100%",
        }}
        className="relative h-96 w-full space-y-5 bg-no-repeat px-4 xl:space-y-7"
      >
        {/* Theme-colored masked layer */}
        <div
          className="absolute inset-0"
          style={{
            background: "var(--theme-color)",
            maskImage: "url('/Home/profile_bg.png')",
            WebkitMaskImage: "url('/Home/profile_bg.png')",
            maskRepeat: "no-repeat",
            WebkitMaskRepeat: "no-repeat",
            maskPosition: "top",
            WebkitMaskPosition: "top",
            maskSize: "100% 70%",
            WebkitMaskSize: "100% 70%",
            opacity: 1,
            pointerEvents: "none",
          }}
        ></div>
        {/* Actual content */}
        <div className="relative z-10">
          <CreateGroupHeader />
          <GroupProfileImage />
          <GroupNameInput />
        </div>
      </div>
      <GroupDescriptionInput />

      <div className="mt-6 px-4">
        <TextTranslate text="Members" />: {CreateGroup.user_id.length} Out Of{" "}
        {groupSettingsData?.settings[0].max_members ?? 10}
      </div>

      <GroupMembersList />
      <DoneButton />
    </div>
  );
}
