
import { useAppSelector, useAppDispatch } from "../../../utils/hooks";
import { Message } from "../../../types/MessageListType";
import { GoDotFill } from "react-icons/go";

export default function ShowStatusReply({
  messageData,
}: {
  messageData: Message;
}) {
  const userData = useAppSelector((state) => state.userData);
  const currentConversation = useAppSelector(
    (state) => state.CurrentConversation,
  );
  if (
    messageData?.Story == undefined
  ) {
    return null;
  }

  return (
    <div className="flex flex-col">
      <div
        onClick={() => {
          // dispatch(
          //   updateNavigateToSpesificMessage({
          //     conversation_id: messageData.conversation_id,
          //     navigate_to_message: true,
          //     message_id: messageData.message_id,
          //   }),
          // );
          // scrollToMessage(repliedMessage?.reply_id!);
        }}
        className="my-1 flex min-w-52 cursor-pointer  items-center gap-2 rounded-xl bg-primary px-3 py-2 text-darkText lg:min-w-72"
      >
        <div className="text-[13px] font-medium">
          {messageData.Story.media?.endsWith(".mp4") ? (
            <video
              className="min-h-10 min-w-10 h-10 w-10 rounded-lg"
              src={messageData.Story.media}
              controls
            />
          ) : (
            <img
              className="min-h-10 min-w-10 h-10 w-10 rounded-lg object-cover"
              src={messageData.Story.media}
              alt=""
            />
          )}
        </div>
        <div className="">
          <div className="flex items-center gap-1">
            {messageData.User.user_id == userData.user_id
              ? "You"
              : currentConversation?.user_name}
            <>
              <GoDotFill className="h-2 w-2 text-lightText" />
              <div className="text-[#FCC604]">Status</div>
            </>
          </div>
          <div className="line-clamp-1 max-w-60 text-xs mt-1">{messageData.Story.caption}</div>
        </div>
      </div>
      <div className="line-clamp-1">

        <div className="gap-1">{messageData.message_content}</div>

      </div>
    </div>
  );
}
