import { ClipLoader } from "react-spinners";
import LoadingSkeletonImageDynamic from "../../../components/LoadingSkeletonImageDynamic";
import { useTheme } from "../../../context/ThemeProvider";
import useApiPost from "../../../hooks/PostData";
import { useBlockUserList } from "../../../store/api/useBlockUserList";
import { useAppDispatch, useAppSelector } from "../../../utils/hooks";
import { useState } from "react";
import TextTranslate from "../../../utils/TextTranslate";
import { BlockUserRes } from "../../../types/ResType";
import ShowSavedName from "../../../components/ShowSavedName";
import { updateCurrentConversation } from "../../../store/Slices/CurrentConversationSlice";
import SearchNotFoundAnimation from "../../../components/SearchNotFoundAnimation";

export default function BlockUserList() {
  const [selectedConversationId, setSelectedConversationId] = useState(0);
  // @ts-ignore
  const { theme } = useTheme();
  const { data, isLoading, refetch } = useBlockUserList();
  const OnlineUserList = useAppSelector((state) => state.OnlineUserList);
  const dispatch = useAppDispatch();
  const { loading, postData } = useApiPost();

  async function unblockUser({ user_id }: { user_id: number }) {
    const blockUserResponse: BlockUserRes = await postData(
      "block/block-unblock",
      {
        user_id: user_id.toString(),
      },
    );
    dispatch(
      updateCurrentConversation({
        is_group_blocked: blockUserResponse.data.is_blocked,
      }),
    );

    // Update the block user list
    refetch();
  }

  return (
    <div className="my-5 flex h-[60vh] w-full max-w-full flex-col overflow-y-auto overflow-x-hidden">
      {isLoading ? (
        <div className="grid h-full place-content-center">
          <ClipLoader size={23} color={theme == "dark" ? "white" : "black"} />
        </div>
      ) : data?.data.Records?.length == 0 ? (
        <div className="grid h-96 place-content-center gap-5">
          <SearchNotFoundAnimation />
          <div>
            <TextTranslate text="No blocked account" />
          </div>
        </div>
      ) : (
        data?.data?.Records?.map((e) => {
          return (
            <>
              <div
                className={`hover:bg-selectedChatdata flex cursor-pointer items-center justify-start px-3 py-4`}
              >
                <div className="relative mr-3 h-14 w-14 2xl:h-12 2xl:w-12">
                  <LoadingSkeletonImageDynamic
                    radius=""
                    className="h-10 w-10 rounded-full object-cover 2xl:h-12 2xl:w-12"
                    image_height="100%"
                    image_url={e?.blocked.profile_pic}
                    image_width=""
                  />
                  {OnlineUserList.onlineUsers.find(
                    (user) => user.user_id == e.user_id,
                  ) && (
                      <img
                        className="absolute bottom-0 right-0 z-30 h-4 w-4"
                        src="/Home/Online_Green_dot.png"
                        alt=""
                      />
                    )}
                </div>

                <div>
                  <div className="text-base font-medium capitalize text-darkText">
                    <ShowSavedName
                      user_id={e?.blocked.user_id.toString()}
                      name={e?.blocked.full_name}
                    />
                  </div>

                  {/* <div className="flex items-center gap-x-1">
                    <div className="line-clamp-1 flex w-full max-w-[12.5rem] gap-x-1 text-[13px] text-lightText">
                      {e.is_group ? e.group_name : e.user_name}
                    </div>
                  </div> */}
                </div>

                <button
                  onClick={() => {
                    // dispatch(
                    //   updateForwardedList({
                    //     user_id: e?.blocked.user_id,
                    //   }),
                    // );
                    unblockUser({
                      user_id: e?.blocked.user_id,
                    });
                    setSelectedConversationId(e?.blocked.user_id);
                  }}
                  className={`relative ml-auto mr-3 h-9 w-28 overflow-hidden rounded-full border border-themeTextColor px-4 text-base font-medium outline-none`}
                >
                  {(loading || isLoading) &&
                    selectedConversationId == e?.blocked.user_id ? (
                    <ClipLoader
                      size={21}
                      color={theme == "dark" ? "white" : "black"}
                    />
                  ) : (
                    "Unblock"
                  )}
                </button>
              </div>
              <hr className="border-t border-borderColor" />
            </>
          );
        })
      )}

      {/* {CreateGroup.user_id.length !== 0 && (
        <div className="absolute bottom-0 flex h-24 w-full items-end bg-gradient-to-t from-primary to-transparent">
          <div
            onClick={() => {
              addMemberToGroup();
              // navigate("/create-group");
            }}
            className="primary-gradient mx-auto my-5 w-[90%] cursor-pointer rounded-lg py-2 text-center"
          >
            {loading ? (
              <ClipLoader
                size={19}
                color={theme == "dark" ? "white" : "black"}
              />
            ) : (
              "Add Member"
            )}
          </div>
        </div>
      )} */}
    </div>
  );
}
