import { useState } from "react";
import { ClipLoader } from "react-spinners";
import { useLocation } from "react-router-dom";
import { useWebsiteSettings } from "../../../store/api/useWebsiteSettings";
// import LandingNavbar from "../LandingPage/LandingNavbar";

export default function TermsAndCondition() {
  const [isIframeLoaded, setIsIframeLoaded] = useState(false);
  const location = useLocation();

  const { data } = useWebsiteSettings();

  const handleIframeLoad = () => {
    setIsIframeLoaded(true);
  };

  return (
    <>
      {!isIframeLoaded && (
        <div className="flex h-screen items-center justify-center bg-white text-black">
          <ClipLoader color="black" size={30} />
        </div>
      )}

      <div
        style={{ display: isIframeLoaded ? "block" : "none" }}
        className={`font-LimerickRegular scrolling-auto scrollbar-thin scrollbar-thumb-gray-300 scrollbar-track-white scrollbar-thumb-rounded-full mx-auto flex h-screen min-h-[50rem] w-screen snap-x snap-mandatory flex-col items-center justify-start overflow-auto overflow-y-auto overflow-x-hidden bg-white ${location.pathname == "/terms-and-condition" ? "pt-20" : ""} lg:px-0 xl:my-auto`}
      >
        <iframe
          srcDoc={data?.data?.terms_and_conditions}
          width="100%"
          height="100%"
          sandbox="allow-same-origin allow-scripts allow-popups"
          onLoad={handleIframeLoad}
        ></iframe>
      </div>
    </>
  );
}
