// @ts-nocheck
import Cookies from "js-cookie";
import { io } from "socket.io-client";

let socket: SocketIOClient;

export const initiateSocketConnection = () => {
  if (!socket) {
    const token = Cookies.get("whoxa_web_token");
    socket = io(import.meta.env.VITE_SOCKET_URL, {
      path: "/socket",
      auth: { token },
    });
  }
  return socket;
};

export const disconnectSocket = () => {
  if (socket) {
    socket.disconnect();
  }
};

export const socketInstance = () => {
  if (!socket) {
    const token = Cookies.get("whoxa_web_token");
    socket = io(import.meta.env.VITE_SOCKET_URL, {
      path: "/socket",
      auth: { token },
    });
  }
  return socket;
};
