import { useQuery } from "react-query";
import { socketQuery } from "../utils/socketQueries";
import { socketInstance } from "./socket";
import { useAppSelector } from "../utils/hooks";

export function useMessageList<T>(chatId: number, user_id: number, page: number) {
  // if (chatId < 0) return null;
  const currentConversationData = useAppSelector(
    (state) => state.CurrentConversation,
  );
  console.log(chatId, "chatId");
  

  return useQuery<T, Error>({
    queryKey: ["message_list", chatId, page],
    queryFn: () =>
      socketQuery(
        socketInstance(),
        "message_list",
        {
          chat_id: chatId,
          user_id: user_id,
          page,
          pinned: true,
          pageSize:
            currentConversationData.unseen_count < 50
              ? 50
              : currentConversationData.unseen_count,
        },
        `message_list`,
      ) as Promise<T>,
    staleTime: Infinity, // never refetch unless manually
    cacheTime: Infinity,
    enabled: chatId > 0, // don’t run until chatId is available
  });
}
