import { createSlice, PayloadAction } from "@reduxjs/toolkit";
import { searchMessageRecord } from "../../types/ResType";

const initialState: searchMessageRecord[] = [];

// Create a slice of the state
const SearchMessageSlice = createSlice({
  name: "SearchMessage",
  initialState,
  reducers: {
    updateSearchMessageResult(
      state,
      action: PayloadAction<searchMessageRecord[]>,
    ) {
      // return { ...state, ...action.payload };
      return action.payload;
    },
  },
});

// Export the reducer and actions
export default SearchMessageSlice.reducer;

export const { updateSearchMessageResult } = SearchMessageSlice.actions;
