import { createSlice, PayloadAction } from "@reduxjs/toolkit";

interface UnSeenMessages {
  chat_id: number;
  message_id: number;
}

const initialState: UnSeenMessages[] = [];

// Create a slice of the state
const UnSeenMessagesSlice = createSlice({
  name: "UnSeenMessages",
  initialState,
  reducers: {
    addUnSeenMessages(state, action: PayloadAction<UnSeenMessages>) {
      state.push(action.payload);
    },
    removeUnSeenMessages(state, action: PayloadAction<UnSeenMessages>) {
      state = state.filter(
        (item) =>
          item.chat_id !== action.payload.chat_id &&
          item.message_id !== action.payload.message_id,
      );
    },
  },
});

// Export the reducer and actions
export default UnSeenMessagesSlice.reducer;
export const { addUnSeenMessages, removeUnSeenMessages } = UnSeenMessagesSlice.actions;
