import { useQuery } from "react-query";
import axios from "axios";
import Cookies from "js-cookie";
import { CallHistoryRes } from "../../types/CallHistoryRes";

export const useCallHistory = () => {
  const token = Cookies.get("whoxa_web_token");
  return useQuery<CallHistoryRes, Error>(
    ["chat/call-history"],
    async () => {
      const response = await axios.post<CallHistoryRes>(
        `${import.meta.env.VITE_API_URL}chat/call-history`,
        {},
        {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        },
      );

      return response.data;
    },
    {
      // Set cache time to prevent re-fetching on route changes
      staleTime: Infinity, // Data will never be considered stale
      cacheTime: Infinity, // Data will never be removed from cache
    },
  );
};
