import { useQuery } from "react-query";
import axios from "axios";
import { LanguageTextListRes } from "../../types/LanguageTextList";
import Cookies from "js-cookie";
import { useAppDispatch } from "../../utils/hooks";
import { updateLanguageTextList } from "../Slices/LanguageTextListSlice";

export const useFetchLanguageTextList = () => {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const updatedFields: any = {};
  // let language_id = localStorage.getItem("language_id");
  const language_id = Cookies.get("language_id");
  const dispatch = useAppDispatch();
  if (language_id) {
    updatedFields.language_id = language_id;
  }

  return useQuery<LanguageTextListRes, Error>(
    ["language/get-language-words"],
    async () => {
      const response = await axios.post<LanguageTextListRes>(
        `${import.meta.env.VITE_API_URL}language/get-language-words`,
        updatedFields,
      );
      dispatch(updateLanguageTextList(response.data));
      return response.data;
    },
    {
      // Set cache time to prevent re-fetching on route changes
      staleTime: Infinity, // Data will never be considered stale
      cacheTime: Infinity, // Data will never be removed from cache
    },
  );
};
